/***************************************************************************
                          ann_ds_buff.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <math.h>
#include <ann_ds_buff.h>

  //                    //
 // class ANN::DS_buff //
//                    //

ANN::Term ANN::DS_buff::nan;

ANN::DS_buff::~DS_buff()
{
  if (data) delete [] data;
}

void
ANN::DS_buff::import(TC *in_, TC *des_out_)
{
  size_t  i, l;
  Term   *des;
  if (in_ && (l=in_->length()))
  {
    resize(in_->get_sizes());
    if (des_out_ && des_out_->length())
      if (des_out) des_resize(des_out_->get_sizes());
      else des_out=new DS_buff_des(*this,des_out_->get_sizes());
    else if (des_out)
    {
      delete des_out;
      des_out=0;
    }
    set_len(l);
    validate();
    for (i=0; i<l; ++i) in_->get_at(i,data[i]);
    if (des_out) if (des=des_out->all_terms())
      for (i=0; i<l; ++i) des_out_->get_at(i,des[i]);
    else  
    {
      reset();
      for (i=0; i<l; ++i)
      {
        des_out_->get_at(i,des_out->term());
        next();
      }  
    }
  }
  reset();  
}

bool
ANN::DS_buff::resize(const Loc &sizes_)
{
  sizes.resize(sizes_);
  invalidate();
  return true;
}

bool
ANN::DS_buff::resize(const Size &sizes_)
{
  sizes.resize(sizes_);
  invalidate();
  return true;
}

bool
ANN::DS_buff::resize(size_t dimension_, size_t *positions_)
{
  sizes.resize(dimension_, positions_);
  invalidate();
  return true;
}

bool
ANN::DS_buff::resize(size_t *positions_)
{
  sizes.resize(positions_);
  invalidate();
  return true;
}

bool
ANN::DS_buff::do_reset()
{
  validate();
  current=0;
  return length!=0;
}

void
ANN::DS_buff::do_next()
{
  validate();
  if (data && length) if (current==size_max) do_reset();
  else if (++current==length) do_reset();
}

bool
ANN::DS_buff::do_seek(size_t term_pos_)
{
  validate();
  if (!data || (length==size_max)) return false;
  if (term_pos_<length)
  {
    current=term_pos_;
    return true;
  }
  current=size_max;
  return false;
}

bool
ANN::DS_buff::do_set_len(size_t len_)
{
  if (length!=len_) invalidate();
  length=len_;
  return true;
}

void
ANN::DS_buff::invalidate()
{
  if (data) delete [] data;
  data=0;
  current=size_max;
}

void
ANN::DS_buff::validate()
{
  if (!data) if (sizes.total_size() && (length!=size_max))
  {
    size_t l=(length ? length : 1), i;
    data=new Term[l];
    for (i=0; i<l; ++i) data[i].resize(sizes);
    current=0;
  }
  else current=size_max;
}

size_t
ANN::DS_buff::get_len() const
{
  return length;
}

const ANN::Size &
ANN::DS_buff::get_sizes() const
{
  return sizes;
}

size_t
ANN::DS_buff::get_size() const
{
  return sizes.total_size();
}

ANN::Term &
ANN::DS_buff::term()
{
  validate();
  if (!current || (current<length)) return data[current];
  nan.resize(0,0);
  return nan;
}

const ANN::Term &
ANN::DS_buff::term() const
{
  if (!current || (current<length)) return data[current];
  nan.resize(0,0);
  return nan;
}

size_t
ANN::DS_buff::where() const
{
  return current;
}

ANN::Term *
ANN::DS_buff::all_terms()
{
  validate();
  return data;
}

const ANN::Term *
ANN::DS_buff::all_terms() const
{
  return data;
}

  //                        //
 // class ANN::DS_buff_des //
//                        //

ANN::DS_buff_des::~DS_buff_des()
{
}

size_t
ANN::DS_buff_des::get_len() const
{
  return in->get_len();
}

size_t
ANN::DS_buff_des::where() const
{
  return in->where();
}

