/***************************************************************************
                          ann_cybenko.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ann_cybenko.h>

namespace ANN
{
  NE_mlayer *
  create_Cybenko(Log *log, const char *label, size_t in, size_t hidden,
                 size_t out, W_FB &w, Act &act, bool bias)
  {
    Size in_size(1,&in);
    Init inst(in_size,label ? label : "Cybenko_net");
    NEC_perc hid_par(log,&w,&act,bias,1,&hidden);
    NEC_perc out_par(log,&w,&Act::linear,bias,1,&out);
    NE_perc_F *factory[]=
    {
      new NE_perc_F(hid_par),
      new NE_perc_F(out_par),
    };
    NE_mlayer *ret=new NE_mlayer(&inst,log,factory,factory+2);
    NE_mlayer::drop_f(factory,factory+2);
    return ret;
  }
} // namespace ANN
