/***************************************************************************
                          ann_act.cpp  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <math.h>
#include <ann_act.h>

  //                //
 // class ANN::Act //
//                //

ANN::Act_sigmoidal ANN::Act::sigmoidal;
ANN::Act_linear    ANN::Act::linear;

  //                          //
 // class ANN::Act_sigmoidal //
//                          //

double
ANN::Act_sigmoidal::fun(double x) const
{
  if (x<0)
  {
    x=exp(x);
    return x/(1+x);
  }
  else
  {
    x=exp(-x);
    return 1/(1+x);
  }
}

double
ANN::Act_sigmoidal::deriv(double x, double y) const
{
  return y*(1-y);
}

  //                       //
 // class ANN::Act_linear //
//                       //

double
ANN::Act_linear::fun(double x) const
{
  return x;
}

double
ANN::Act_linear::deriv(double x, double y) const
{
  return 1;
}

