/***************************************************************************
                          ann_tc_set.h  -  description
                             -------------------
    begin                : sob kwi 19 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __TC_SET_H
#define __TC_SET_H

#include <set>
#include <vector>

#include <ann_tc.h>

namespace ANN
{

  class TC_set;
  
  //              //
 // class TC_set //
//              //

  class TC_set : public TC
  {
  public:  
    struct Token
    {
      Loc    loc;
      double d;
      Token(size_t dim, const size_t *pos, double d_) : loc(dim,pos), d(d_) {}
    };
    struct TokenCmp
    { bool operator ()(const Token *t1, const Token *t2) const; };
    typedef std::set<Token *,TokenCmp> TokenSet;
    typedef TokenSet::iterator         TSIterator;
    typedef std::vector<TokenSet *>    TokenSets;
    typedef TokenSets::iterator        TSsIterator;

  protected:
    TokenSets tokens;

    virtual bool calc_sizes(size_t num, Size &lim_);
    virtual void reserve(size_t num_);
    
  public:
    TC_set() {}
    ~TC_set();

    virtual void append(double d);
    virtual bool get_next(Term &term);
    virtual bool erase(size_t num);
    virtual void shrink();
  };
    
} // namespace ANN

#endif /* __TC_SET_H */
