/***************************************************************************
                          ann_tc.h  -  description
                             -------------------
    begin                : sob kwi 19 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_TC_H
#define __ANN_TC_H

#include <ann_term.h>

namespace ANN
{
  class TC; /* term collector */

  //          //
 // class TC //
//          //

  class TC
  {
  protected:
    Loc    cur;
    Size   lim;
    size_t l;
    size_t num_get, num_put, num_term;
    bool   lim_valid;

    void         recalc_size();
    virtual bool calc_sizes(size_t num, Size &lim_)=0;
    virtual void reset();
    virtual void reserve(size_t num)=0;
    
  public:
    TC()
    : l(size_max), num_get(0), num_put(0), num_term(0), lim_valid(true) {}
    virtual ~TC();

    size_t         level() const { return l; }
    size_t         length() const { return num_term; }
    const Size    &get_sizes() { if (!lim_valid) recalc_size(); return lim; }
    virtual void   inc_level();
    virtual bool   dec_level();
    virtual void   append(double d)=0;
    virtual size_t put_next();
    virtual void   put_at(size_t num);
    virtual bool   get_next(Term &term)=0;
    virtual bool   get_at(size_t num, Term &term);
    virtual bool   erase(size_t num)=0;
    virtual void   shrink()=0;
  };
  
} // namespace ANN

#endif /* __ANN_TC_H */
