/***************************************************************************
                          ann_parser_log.h  -  description
                             -------------------
    begin                : sob kwi 19 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_PARSER_LOG_H
#define __ANN_PARSER_LOG_H

#include <iostream>

#include <ann_time.h>
#include <ann_tc.h>

namespace ANN
{

  class Parser_log;

  //                  //
 // class Parser_log //
//                  //

  class Parser_log
  {
  private:
    Parser_log(const Parser_log &that);

  protected:
    std::istream  *is;
    Time          *time;
    Time::Buffer   stamp;
    time_t         last_stamp;
    char           sep, sub_beg, sub_end;
    char          *buff;
    size_t         pos;
    size_t         len;
    bool           after_stamp;

    void add_word(TC &result, size_t l);
    
  public:
    Parser_log(std::istream &is_, char sublevel_beg=0, char sublevel_end=0,
               char sep_=0);
    Parser_log(std::istream &is_, Time &time_, char sublevel_beg=0,
               char sublevel_end=0, char sep_=0);
    virtual ~Parser_log();

    time_t when() const { return last_stamp; }
    void   set_separator(char sep_=0);
    char   get_separator() const { return sep; }
    void   set_sublevel(char sublevel_beg=0, char sublabel_end=0);
    bool   seek(time_t t); /* positinos in the log at given time/date */
    bool   shift(); /* shifts one line */
    bool   find(const char *label, char *&rest);
    /* search for a label, return the rest of the text between a new line
     * character or a term separator */
    bool   find(const char *label);
    /* search for a label followed by a new line or a term separator */
    bool   load(TC &result);
    /* loads a term to a term container */
  };

} // namespace ANN

#endif /* __ANN_PARSER_LOG_H */
