/***************************************************************************
                          ann_ls_set.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_LS_SET_H
#define __ANN_LS_SET_H

#include <set>

#include <cmp_ptr.h>
#include <ann_log.h>

namespace ANN
{

  class LS_set;

  //              //
 // class LS_set //
//              //

  class LS_set : public LS
  {
  protected:
    typedef std::set<Log_rec *,CmpPtr> LogSet;
    typedef LogSet::iterator           Iterator;

    LogSet children;
    
  public:
    LS_set() {}
    virtual ~LS_set();

    virtual bool  attach(Log_rec &child);
    virtual bool  detach(Log_rec &child);
    virtual void  reset();
    virtual void  prepare(size_t epoch);
    virtual void  stepped(size_t step_, size_t pos_);
    virtual void  update(size_t epoch);
    virtual void  finish(size_t epoch);
    virtual void  finished(size_t epoch);
  };

} // namespace ANN

#endif /* __ANN_LS_SET_H */
