/***************************************************************************
                          ann_log_io.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_LOG_IO_H
#define __ANN_LOG_IO_H

#include <iostream>

#include <ann_log.h>

namespace ANN
{

  class Log_io;
  
  //              //
 // class Log_io //
//              //

  class Log_io : public Log
  {
  private:
    Log_io();
    Log_io(const Log_io &that);
    
  protected:
    std::ostream  *os;
    int            marg;
    Time          *time;
    Time::Buffer   stamp;
    size_t         epoch, step, pos;
    char           sep, sub_beg, sub_end;
    bool           is_first, ch_epoch, ch_step;

    void          write_sep();
    virtual void  new_line(int ch_marg, const char *label);
    virtual void  log_chr(char chr);
    virtual void  log_str(const char *str);
    virtual void  log_int(int i);
    virtual void  log_uint(unsigned int u);
    virtual void  log_double(double d);

  public:
    Log_io(std::ostream &os_, const char sep_=' ', char sub_beg_='{',
           char sub_end_='}');
    Log_io(Time &time_, std::ostream &os_, const char sep_=' ',
           char sub_beg_='{', char sub_end_='}');
    virtual ~Log_io();

    virtual Time   &get_time() const;
    virtual char    get_separator() const;
    virtual char    get_sublevel_beg() const;
    virtual char    get_sublevel_end() const;
    virtual size_t  get_margin() const;
    virtual void    reset(const char *label_=0);
    virtual void    prepare(size_t epoch_);
    virtual void    stepped(size_t step_, size_t pos_);
    virtual void    update(size_t epoch_);
    virtual void    finish(size_t epoch_);
    virtual void    finished(size_t epoch_);
    virtual Log    &flush();
  };

} // namespace ANN

#endif /* __ANN_LOG_IO_H */
