/***************************************************************************
                          ann_init.h  -  description
                             -------------------
    begin                : wto kwi 22 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_INIT_H
#define __ANN_INIT_H

#include <ctype.h>

#include <ann_loc.h>

namespace ANN
{

  class Label;
  class Init;
  
  //             //
 // class Label //
//             //

  class Label
  {
  private:
    Label();

  protected:
    char   *buffer;
    size_t  len;
    size_t  cap;

  public:

    Label(const char *label_);
    Label(const Label &that);
    Label(const Label *that);
    virtual ~Label();

    const char  *label() const { return buffer; }
    char        *dup_label () const;
    static char *dup_str (const char *str_);
    size_t       length() const { return len; }
    void         resize(size_t capacity_);
    void         set_label(const char *label, size_t pos=0);
    void         set_index(size_t index, size_t pos=0);
  };

  //            //
 // class Init //
//            //

  class Init : public Label
  {
  private:
    Init();

  public:
    const Size *size;

    Init(const Size &size_, const char *label_)
    : Label(label_), size(&size_) {}
    Init(const Init &that) : Label(that), size(that.size) {}
    Init(const Init *that) : Label(that), size(that->size) {}
    virtual ~Init();
  };

} // namespace ANN

#endif /* __ANN_INIT_H */
