/***************************************************************************
                          ann_ds_rec.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_DS_REC_H
#define __ANN_DS_REC_H

#include <ctype.h>

#include <ann_loc.h>
#include <ann_ds.h>

namespace ANN
{

  class DS_rec;     /* recurent data source */
  class DS_rec_des; /* recurent data source for desired output */

  //              //
 // class DS_rec //
//              //

  class DS_rec : public virtual DS
  {
  private:
    DS_rec();

  protected:
    DS *orig;

    DS_rec(DS &orig_, bool mk_des=true);

    virtual bool     do_reset();
    virtual void     do_next();
    virtual bool     do_seek(size_t term_pos_);

  public:
    virtual ~DS_rec();

    virtual size_t      get_len() const;
    virtual const Size &get_sizes() const;
    virtual size_t      get_size() const;
    virtual Term       &term();
    virtual const Term &term() const;
    virtual size_t      where() const;
  };

  //                  //
 // class DS_rec_des //
//                  //

  class DS_rec_des : public DS_rec, public DS_des
  {
  private:
    DS_rec_des();
    DS_rec_des(const DS_rec_des &that);

  protected:
    virtual bool     do_reset();
    virtual void     do_next();
    virtual bool     do_seek(size_t term_pos_);

  public:
    DS_rec_des(DS &in_, DS &orig_)
    : DS(this), DS_rec(orig_,false), DS_des(in_) {}
    ~DS_rec_des();

    virtual size_t   get_len() const;
    virtual size_t      where() const;
  };

} // namespace ANN

#endif /* __ANN_DS_REC_H */
