/***************************************************************************
                          ann_ds_buff.h  -  description
                             -------------------
    begin                : pon kwi 14 2003
    copyright            : (C) 2003 by Bartosz Lis
    email                : bartoszl@ics.p.lodz.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ANN_DS_BUFF_H
#define __ANN_DS_BUFF_H

#include <ctype.h>

#include <ann_loc.h>
#include <ann_ds.h>
#include <ann_tc.h>

namespace ANN
{

  class DS_buff;      /* buffered data source */
  class DS_buff_des;  /* buffered data source for desired output */

  //               //
 // class DS_buff //
//               //

  class DS_buff : public virtual DS
  {
  private:
    Size         sizes;
    size_t       length;
    size_t       current;
    Term        *data;
    static Term  nan;

    DS_buff(const DS_buff &that);

  protected:
    DS_buff()
    : length(size_max), current(size_max), data(0) {}
    DS_buff(size_t length_, const Loc &sizes_)
    : sizes(sizes_), length(length_), current(size_max), data(0) {}
    DS_buff(size_t length_, const Size &sizes_)
    : sizes(sizes_), length(length_), current(size_max), data(0) {}
    DS_buff(size_t length_, size_t dimension_, size_t *positions_=0)
    : sizes(dimension_, positions_), length(length_), current(size_max), 
      data(0) {}
    DS_buff(size_t length_, size_t *positions_)
    : sizes(positions_), length(length_), current(size_max), data(0) {}
    virtual ~DS_buff();

    void           import(TC *in_, TC *des_out_);
    virtual bool   resize(const Loc &sizes_);
    virtual bool   resize(const Size &sizes_);
    virtual bool   resize(size_t dimension_, size_t *positions_);
    virtual bool   resize(size_t *positions_);
    virtual bool   do_reset();
    virtual void   do_next();
    virtual bool   do_seek(size_t term_pos_);
    virtual bool   do_set_len(size_t len_);
    void           invalidate();
    void           validate();

    inline bool    des_resize(const Loc &sizes_);
    inline bool    des_resize(const Size &sizes_);
    inline bool    des_resize(size_t dimension_, size_t *positions_=0);
    inline bool    des_resize(size_t *positions_);

  public:
    DS_buff(TC &in_, TC &des_out_)
    : length(size_max), current(size_max), data(0) { import(&in_,&des_out_); }
    DS_buff(TC *in_, TC *des_out_)
    : length(size_max), current(size_max), data(0) { import(in_,des_out_); }
    
    virtual size_t      get_len() const;
    virtual const Size &get_sizes() const; /* term sizes */
    virtual size_t      get_size() const;  /* returns overall term size */
    virtual Term       &term();
    virtual const Term &term() const;
    virtual size_t      where() const;
    virtual Term       *all_terms();
    virtual const Term *all_terms() const;

 };

  //                   //
 // class DS_buff_des //
//                   //

  class DS_buff_des : public DS_buff, public DS_des
  {
  public:
    DS_buff_des(DS &in_)
    : DS(this), DS_buff(), DS_des(in_) {}
    DS_buff_des(DS &in_, const Loc &sizes_)
    : DS(this), DS_buff(in_.get_len(),sizes_), DS_des(in_) {}
    DS_buff_des(DS &in_, const Size &sizes_)
    : DS(this), DS_buff(in_.get_len(),sizes_), DS_des(in_) {}
    DS_buff_des(DS &in_, size_t dimension_, size_t *positions_=0)
    : DS(this), DS_buff(in_.get_len(),dimension_,positions_), DS_des(in_) {}
    DS_buff_des(DS &in_, size_t *positions_)
    : DS(this), DS_buff(in_.get_len(),positions_), DS_des(in_) {}
    virtual ~DS_buff_des();

    virtual size_t get_len() const;
    virtual size_t where() const;
  };

} // namespace ANN

bool
ANN::DS_buff::des_resize(const Loc &sizes_)
{
  if (des_out) return ANN::DS_buff::des_resize(sizes_);
  des_out=new DS_buff_des(*this,sizes_);
  return true;
}

bool
ANN::DS_buff::des_resize(const Size &sizes_)
{
  if (des_out) return ANN::DS_buff::des_resize(sizes_);
  des_out=new DS_buff_des(*this,sizes_);
  return true;
}

bool
ANN::DS_buff::des_resize(size_t dimension_, size_t *positions_)
{
  if (des_out) return ANN::DS_buff::des_resize(dimension_,positions_);
  des_out=new DS_buff_des(*this,dimension_,positions_);
  return true;
}

bool
ANN::DS_buff::des_resize(size_t *positions_)
{
  if (des_out) return ANN::DS_buff::des_resize(positions_);
  des_out=new DS_buff_des(*this,positions_);
  return true;
}

#endif /* __ANN_DS_BUFF_H */
