#ifndef __DRACAUTH_H
#define __DRACAUTH_H

/*
 * DRAC client library functions:
 *
 * dracauth(server, userip, errmsg)
 * 	server = hostname of DRAC server
 * 	userip = IP address to authorize for relaying
 *	errmsg = place to store pointer to error message
 *
 * dracconn(server, errmsg)
 * 	server = hostname of DRAC server
 *	errmsg = place to store pointer to error message
 * dracsend(userip, errmsg)
 * 	userip = IP address to authorize for relaying
 *	errmsg = place to store pointer to error message
 * dracdisc(errmsg)
 *	errmsg = place to store pointer to error message
 */

#include <netinet/in.h>
#include <arpa/inet.h>

int dracauth(char *server, unsigned long userip, char **errmsg);
int dracconn(char *server, char **errmsg);
int dracsend(unsigned long userip, char **errmsg);
int dracdisc(char **errmsg);

#endif /* __DRACAUTH_H */
