/* vi: set sw=4 ts=4: */
/*
 * Copyright (C) 2001 Christian Hohnstaedt.
 *
 *  All rights reserved.
 *
 *
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *  - Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *  - Neither the name of the author nor the names of its contributors may be 
 *    used to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 * This program links to software with different licenses from:
 *
 *	http://www.openssl.org which includes cryptographic software
 * 	written by Eric Young (eay@cryptsoft.com)"
 *
 *	http://www.sleepycat.com
 *
 *	http://www.trolltech.com
 * 
 *
 *
 * http://www.hohnstaedt.de/xca
 * email: christian@hohnstaedt.de
 *
 * $Id: x509name.h,v 1.11 2003/11/25 15:56:46 chris2511 Exp $
 *
 */                           

#ifndef X509NAME_H
#define X509NAME_H

#include <qstring.h>
#include <qstringlist.h>
#include <openssl/x509.h>

class x509name
{
   private:	
	X509_NAME *xn;
   public:
	x509name();
	x509name(const X509_NAME *n);
	x509name(const x509name &n);
	~x509name();
	x509name &set(const X509_NAME *n);
	QString oneLine() const;
	int nid(int i) const;
	unsigned char *d2i(unsigned char *p, int size);
	unsigned char *i2d(unsigned char *p);
	QStringList entryList(int i) const;
	QString getEntryByNid(int nid ) const;
	QString getEntry(int i) const;
	int entryCount() const;
	x509name &operator = (const x509name &x);
	bool operator == (const x509name &x) const;
	static int getNidByName(const QString &nid_name);
	void addEntryByNid(int nid, const QString entry);
	void delEntry(int i);
	X509_NAME *get() const;
	int derSize() const;
	void write_fp(FILE *fp) const;
	void read_fp(FILE *fp);

		
};

#endif
