/*
 * Copyright (C) 2002 Bartosz Lis <bartoszl@ics.p.lodz.pl>
 * This module is used to set password
 */

#define _GNU_SOURCE
#include "config.h"

#include <security/_pam_types.h>
#include <security/pam_appl.h>
#include <security/pam_misc.h>
#include <string.h>
#include <stdlib.h>

#include "setpass.h"

struct conv_data_t
{
  ask_pass_t  ask_pass;
  int         stage;
  void       *data;
};

static int
conversation(int num_msg, const struct pam_message **msg,
             struct pam_response **resp, void *appdata_ptr)
{
   int                 ret, i;
   struct conv_data_t *conv_data=(struct conv_data_t *)appdata_ptr;
   char               *answer;
   if (!appdata_ptr || !num_msg) return PAM_CONV_ERR;
   if (!(*resp=(struct pam_response *)calloc(num_msg,
                                             sizeof(struct pam_response))))
     return PAM_CONV_ERR;
   ret=PAM_SUCCESS;
   for (i=0; i<num_msg; ++i)
     {
        (*resp)[i].resp=NULL;
        (*resp)[i].resp_retcode=0;
     }
   for (i=0; (i<num_msg) && (ret==PAM_SUCCESS); ++i) switch (conv_data->stage)
     {
      case SETPASS_STAGE_OLD:
        if ((msg[i]->msg_style==PAM_PROMPT_ECHO_OFF)
            && !strcmp(msg[i]->msg,PASS_PROMPT_OLD))
          {
             if (answer=(*conv_data->ask_pass)(conv_data->data,msg[i]->msg,
                                               SETPASS_STAGE_OLD))
               {
                  (*resp)[i].resp=(char *)x_strdup(answer);
                  _pam_overwrite(answer);
                  conv_data->stage=SETPASS_STAGE_NEW;
               }
             else ret=PAM_CONV_ERR;
             break;
          }
      case SETPASS_STAGE_NEW:
        if ((msg[i]->msg_style==PAM_PROMPT_ECHO_OFF)
            && !strcmp(msg[i]->msg,PASS_PROMPT_NEW))
          {
             if (answer=(*conv_data->ask_pass)(conv_data->data,msg[i]->msg,
                                               SETPASS_STAGE_NEW))
               {
                  (*resp)[i].resp=(char *)x_strdup(answer);
                  _pam_overwrite(answer);
                  conv_data->stage=SETPASS_STAGE_NEW_AGAIN;
               }
             else ret=PAM_CONV_ERR;
             break;
          }
      case SETPASS_STAGE_NEW_AGAIN:
        if ((msg[i]->msg_style==PAM_PROMPT_ECHO_OFF)
            && !strcmp(msg[i]->msg,PASS_PROMPT_NEW_AGAIN))
          {
             if (answer=(*conv_data->ask_pass)(conv_data->data,msg[i]->msg,
                                               SETPASS_STAGE_NEW_AGAIN))
               {
                  (*resp)[i].resp=(char *)x_strdup(answer);
                  _pam_overwrite(answer);
                  conv_data->stage=SETPASS_STAGE_MESSAGE;
               }
             else ret=PAM_CONV_ERR;
             break;
          }
      case SETPASS_STAGE_MESSAGE:
        if ((msg[i]->msg_style==PAM_ERROR_MSG)
            || (msg[i]->msg_style==PAM_TEXT_INFO))
          {
             (*conv_data->ask_pass)(conv_data->data,msg[i]->msg,
                                    SETPASS_STAGE_MESSAGE);
             break;
          }
      default:
        ret=PAM_CONV_ERR;
     }
  return ret;
}

int
set_pass(void *data, const char *user, ask_pass_t ask_pass, int flags)
{
  int                  ret;
  pam_handle_t        *handle;
  struct pam_conv      conv;
  struct conv_data_t   conv_data;
  conv_data.ask_pass=ask_pass;
  conv_data.stage=SETPASS_STAGE_OLD;
  conv_data.data=data;
  conv.conv=&conversation;
  conv.appdata_ptr=&conv_data;
  ret=pam_start("passwd"/*PAM_SERVICE_NAME*/,user,&conv,&handle);
  if (ret==PAM_SUCCESS) ret=pam_chauthtok(handle,flags);
  pam_end(handle,ret);
  return ret;
}

